import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import javax.swing.JComponent;


public class ColorSquareComponent extends JComponent {
   
   private Color fillColor;
   final int SQUARE_WIDTH = 100;
   
   public ColorSquareComponent(Color aColor) {
      this.fillColor = aColor;
   }
   
   @Override
   public void paintComponent(Graphics g) {
      Graphics2D g2 = (Graphics2D)g;
      g2.setColor(fillColor);
      
      Rectangle square = new Rectangle(
            (this.getWidth() - SQUARE_WIDTH)/2,
            (this.getHeight() - SQUARE_WIDTH)/2,
            SQUARE_WIDTH,
            SQUARE_WIDTH);
      
      g2.fill(square);
      
      g2.drawString("My Square", 100, 350);
      
   }

}
